<?php
/**
 * Theme Specific Filters
 *
 * @package physio-qt
 */

/**
 * Add shortcodes in widgets
 */
add_filter( 'widget_text', 'do_shortcode' );

/**
 * Custom font size for tags
 */
if ( ! function_exists( 'physio_qt_tag_font_size' ) ) {
	function physio_qt_tag_font_size( $args ) {
		$args['number'] = 12;
		$args['largest'] = 11;
		$args['smallest'] = 9;

		return $args;
	}
	add_filter( 'widget_tag_cloud_args', 'physio_qt_tag_font_size' );
}

/**
 * Wrap embeds in a wrapper
 */
if ( ! function_exists( 'thelandscaper_oembed_html' ) ) {
    function thelandscaper_oembed_html( $html, $url, $attr, $post_id ) {
        return '<div class="embed-responsive embed-responsive-16by9">' . $html . '</div>';
    }
    add_filter( 'embed_oembed_html', 'thelandscaper_oembed_html', 99, 4 );
}

/**
 * Adds custom classes to the array of body classes.
 */
if ( ! function_exists( 'physio_qt_body_classes' ) ) {
	function physio_qt_body_classes( $class ) {

		$page_id = physio_qt_get_the_ID();

		// If boxed layout theme mod isset to boxed add class to body
		if ( 'boxed' === get_theme_mod( 'boxed_layout', 'wide' ) ) {
			$class[] = 'boxed';
		}

		// If sticky navigation theme mod isset to sticky add class to body
		if ( 'sticky' === get_theme_mod( 'nav_position', 'static' ) ) {
			$class[] = 'sticky-navigation';
		}

		// If doubletab is enabled add class to body
		if ( 'yes' === get_theme_mod( 'nav_double_tap', 'yes' ) ) {
			$class[] = 'doubletap';
		}

		// Add theme button class
		$class[] = get_theme_mod( 'button_layout', '' );

		// Add the Font Awesome version class to the body
        $class[] = 'font-awesome-'. esc_attr( get_theme_mod( 'qt_fontawesome_version', '4' ) );

        // Add class to hide widget bar from mobile or desktop screens
        $class[] = 'widget-bar-'. esc_attr( get_theme_mod( 'header_widgets', 'show' ) );

		// Add the widget bar overlay class based on active widgets, display option and background type option
		if ( is_active_sidebar( 'header-sidebar' ) && 'no_overlay' != get_theme_mod( 'header_widgets_absolute', 'overlay' ) && 'hide' != get_field( 'widget_bar' ) && ( 'show' == get_theme_mod( 'header_widgets', 'show' ) || 'hide-mobile' == get_theme_mod( 'header_widgets', 'hide-mobile' ) ) ) {
			$class[] = 'widget-bar-overlay';
		}

		// If page header isset to hidden add class to body
		if ( 'hide' === get_theme_mod( 'page_header', 'show' ) || 'hide' === get_field( 'page_header' ) ) {
			$class[] = 'hide-page-header';
		}

		// Add the class for the sidebar position
        $get_sidebar = get_field( 'sidebar', $page_id );

        if ( is_single() && 'post' === get_post_type() ) {
            $get_sidebar = get_field( 'sidebar', get_option( 'page_for_posts' ) );
        }

        if ( physio_qt_woocommerce_active() && is_woocommerce() ) {
            $get_sidebar = physio_qt_single_product_sidebar();
        }

        if ( ! $get_sidebar ) { 
            $get_sidebar = 'hide';
        }

        if ( ! $page_id ) { 
            $get_sidebar = 'right';
        }

        $class[] = 'sidebar-'. esc_attr( strtolower( $get_sidebar ) );

		// If page header isset to hidden add class to body
		if ( 'hide' !== get_field( 'sidebar' ) && 'pull' === get_field( 'pull_sidebar' ) ) {
			$class[] = 'pull-sidebar';
		}

		// Adds a class of group-blog to blogs with more than 1 published author.
		if ( is_multi_author() ) {
			$class[] = 'group-blog';
		}

		return $class;
	}
	add_filter( 'body_class', 'physio_qt_body_classes' );
}

/**
 * Get selected Google fonts from the customizer
 */
if ( ! function_exists( 'physio_qt_get_customizer_fonts' ) ) {
    function physio_qt_get_customizer_fonts( $fonts ) {

        // Get the customizer font type settings
        $primary_font = get_theme_mod( 'theme_primary_font', 'Open Sans' );
        $secondary_font = get_theme_mod( 'theme_secondary_font', 'Nunito' );

        // Get selected fonts and set default font weight (400 is regular)
        $font_primary = array( $primary_font => array( '400', '700' ) );
        $font_secondary = array( $secondary_font => array( '400', '700' ) );

        // Merge everything and remove duplicated
        $fonts = array_merge( $font_primary, $font_secondary );
        $fonts = array_map( 'array_unique', $fonts );

        return $fonts;
    }
    add_filter( 'pre_google_web_fonts', 'physio_qt_get_customizer_fonts' );
}

/**
 * Custom read more link
 */
if ( ! function_exists( 'physio_qt_read_more_link' ) ) {
	function physio_qt_read_more_link() {

		$read_more = get_theme_mod( 'blog_read_more', 'Read More' );

        if ( ! $read_more ) {
            $read_more = esc_html__( 'Read More', 'physio-qt' );
        }

		return '<p><a href="'. esc_url( get_permalink() ) .'" class="hentry--more">'. esc_html( $read_more ) .'</a></p>';
	}
	add_filter( 'the_content_more_link', 'physio_qt_read_more_link' );
}

/**
 * Allow skype in URLS to protocol
 **/
if ( ! function_exists( 'physio_qt_allow_skype_protocol' ) ) {
	function physio_qt_allow_skype_protocol( $protocols ) {
	    $protocols[] = 'skype';
	    $protocols[] = 'whatsapp';
	    return $protocols;
	}
	add_filter( 'kses_allowed_protocols' , 'physio_qt_allow_skype_protocol' );
}

/*
 * Enable font sizes in the TinyMCE editor
 */
if ( ! function_exists( 'physio_qt_enable_mce_fontsize' ) ) {
	function physio_qt_enable_mce_fontsize( $buttons ) {

	        array_shift( $buttons );
	        array_unshift( $buttons, 'fontsizeselect');

	        return $buttons;
	}    
	add_filter( 'mce_buttons_2', 'physio_qt_enable_mce_fontsize');
}

/*
 * Change font sizes default points to pixels
 */
if ( ! function_exists( 'physio_qt_change_text_sizes' ) ) {
	function physio_qt_change_text_sizes( $initArray ) {
		$initArray['fontsize_formats'] = "9px 10px 12px 13px 14px 16px 18px 21px 24px 28px 32px 36px";
		return $initArray;
	}
	add_filter( 'tiny_mce_before_init', 'physio_qt_change_text_sizes' );
}

/**
 * Define the custom options for the SiteOrigin Page Builder
 */
if ( ! function_exists( 'physio_qt_custom_pagebuilder_widget_styles' ) ) {
	function physio_qt_custom_pagebuilder_widget_styles( $fields ) {
	
		$fields['big_widget_title'] = array(
			'name'			=> esc_html__( 'Big Widget Title', 'physio-qt' ),
			'type'			=> 'checkbox',
			'group'			=> 'design',
			'label'			=> esc_html__( 'Use bigger widget title', 'physio-qt' ),
			'priority'		=> 16,
		);

		$fields['small_widget_title'] = array(
			'name'			=> esc_html__( 'Small Widget Title', 'physio-qt' ),
			'type'			=> 'checkbox',
			'group'			=> 'design',
			'label'			=> esc_html__( 'Use smaller widget title', 'physio-qt' ),
			'priority'		=> 17,
		);

		$fields['white_widget_title'] = array(
			'name'			=> esc_html__( 'White Widget Title', 'physio-qt' ),
			'type'			=> 'checkbox',
			'group'			=> 'design',
			'label'			=> esc_html__( 'Use white colored title', 'physio-qt' ),
			'priority'		=> 18,
		);

		$fields['featured_box'] = array(
			'name'			=> esc_html__( 'Featured Box', 'physio-qt' ),
			'type'			=> 'checkbox',
			'group'			=> 'design',
			'label'			=> esc_html__( 'Set widget in color featured box', 'physio-qt' ),
			'priority'		=> 19,
		);

		$fields['white_featured_box'] = array(
			'name'			=> esc_html__( 'White Featured Box', 'physio-qt' ),
			'type'			=> 'checkbox',
			'group'			=> 'design',
			'label'			=> esc_html__( 'Set widget in white featured box', 'physio-qt' ),
			'priority'		=> 20,
		);

		return $fields;
	}

	add_filter( 'siteorigin_panels_widget_style_fields', 'physio_qt_custom_pagebuilder_widget_styles' );
}

/**
 * Add some custom option to the SiteOrigin Page Builder widget styles panel
 */
if ( ! function_exists( 'physio_qt_output_custom_pagebuilder_widget_styles' ) ) {
	function physio_qt_output_custom_pagebuilder_widget_styles( $attributes, $args ) {

		if ( ! empty( $args['big_widget_title'] ) ) {
			array_push( $attributes['class'], 'bigger-widget-title' );
		}

		if ( ! empty( $args['small_widget_title'] ) ) {
			array_push( $attributes['class'], 'smaller-widget-title' );
		}

		if ( ! empty( $args['white_widget_title'] ) ) {
			array_push( $attributes['class'], 'white-title' );
		}

		if ( ! empty( $args['featured_box'] ) ) {
			array_push( $attributes['class'], 'featured-box' );
		}

		if ( ! empty( $args['white_featured_box'] ) ) {
			array_push( $attributes['class'], 'white-featured-box' );
		}

		return $attributes;
	}
	add_filter( 'siteorigin_panels_widget_style_attributes', 'physio_qt_output_custom_pagebuilder_widget_styles', 10, 2 );
}

/**
 * Change some default SiteOrigin Page Builder settings
 */
if ( ! function_exists( 'physio_qt_siteorigin_default_settings' ) ) {
	function physio_qt_siteorigin_default_settings( $settings ) {
		$settings['mobile-width'] = '991';

		return $settings;
	}
	add_filter( 'siteorigin_panels_settings_defaults', 'physio_qt_siteorigin_default_settings' );
}

/**
 * Set default active SiteOrigin Widgets from the Bundle Plugin
 */
if ( ! function_exists( 'physio_qt_filter_active_siteorigin_widgets' ) ) {
	function physio_qt_filter_active_siteorigin_widgets( $active ){
	    $active['so-button-widget'] = false;
	    $active['so-image-widget'] = false;
	    $active['so-post-carousel-widget'] = false;
	    $active['so-google-map-widget'] = true;
	    $active['so-slider-widget'] = true;
	    $active['so-editor-widget'] = true;

	    return $active;
	}
	add_filter('siteorigin_widgets_active_widgets', 'physio_qt_filter_active_siteorigin_widgets');
}

/**
 * Hide the live editor button in the admin bar by default
 */
if ( ! function_exists( 'physio_qt_hide_live_editor_adminbar' ) ) {
    function physio_qt_hide_live_editor_adminbar( $defaults ) {
        $defaults['live-editor-quick-link'] = false;
        return $defaults;
    }
    add_filter( 'siteorigin_panels_settings_defaults', 'physio_qt_hide_live_editor_adminbar' );
}

/**
 * Remove the SiteOrigin page builder premium teaser
 */
add_filter( 'siteorigin_premium_upgrade_teaser', '__return_false' );

/**
 * Define our prebuilt templates to the page builder layouts modal
 */
if ( ! function_exists( 'physio_qt_prebuilt_page_layouts' ) ) {
    function physio_qt_prebuilt_page_layouts( $layouts ) {

    	$layouts['homepage'] = array_merge(
            array(
                'name'          => esc_html__( 'Homepage', 'physio-qt' ),
                'description'   => esc_html__( 'Slider need to configured manually. Please select the slider page template to enable the slider on the page', 'physio-qt' ),
                'screenshot'    => get_theme_file_uri( '/assets/images/pre-built/homepage.png' ),
            ),
            json_decode( '{"widgets":[{"title":"We offer various Physio Disciplines","text":"<p>We are proud to offer a wide range of comprehensive services to meet the needs of adults, seniors, and pediatric patients. Our team of professional caregivers specialize in providing personalized medical care, rehabilitative therapy and companion assistance.</p><p>[button href=\"#\"]See all Services[/button]</p>","text_selected_editor":"tinymce","autop":true,"_sow_form_id":"5693b56d812a8","id":"sow-editor-5510000","option_name":"widget_sow-editor","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":0,"id":0,"widget_id":"292d2888-ba56-4950-bf83-28ffdfdeaaf8","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"page_id":307,"btn_text":"Find out More","id":"qt_feature_page-5510001","option_name":"widget_qt_feature_page","panels_info":{"class":"QT_Feature_Page","raw":false,"grid":0,"cell":1,"id":1,"widget_id":"1ffe4a17-e670-4fde-959f-e4e60dd0cf18","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"page_id":6266,"btn_text":"Find out More","id":"qt_feature_page-5510002","option_name":"widget_qt_feature_page","panels_info":{"class":"QT_Feature_Page","raw":false,"grid":0,"cell":2,"id":2,"widget_id":"03343c67-528f-4466-8a41-fa0cec2af26f","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"page_id":6397,"btn_text":"Find out More","id":"qt_feature_page-5510003","option_name":"widget_qt_feature_page","panels_info":{"class":"QT_Feature_Page","raw":false,"grid":0,"cell":3,"id":3,"widget_id":"f11a59a5-d890-4505-b761-16f34edfab68","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"About Us","text":"<p><a href=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\" rel=\"attachment wp-att-6992\"><img class=\"wp-image-7481 size-medium alignleft\" src=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567-300x200.png\" alt=\"\" width=\"300\" height=\"200\" /></a></p><p><a href=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x425.png\" rel=\"attachment wp-att-6532\"><img class=\"wp-image-7480 size-medium alignleft\" src=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x425-300x150.png\" alt=\"\" width=\"300\" height=\"150\" /></a></p><p>Our team of highly trained <strong><a href=\"#\">professionals</a></strong> uses the latest healing technologies to restore you to pain-free health, quickly and easily. We thoroughly evaluate &amp; treat all of the contributing root factors related to your issue. This includes, but is not limited to, your work and home stressors, overall body condition, nutrition, genetic &amp; postural habits, emotional connections and patterns that are held in your muscles</p><p><img class=\"alignnone size-full wp-image-6983\" style=\"opacity: 0.2; margin-bottom: 0;\" src=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2016/01/sig.png\" alt=\"sig\" width=\"158\" height=\"37\" /></p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56ace5197def8","id":"sow-editor-5510004","option_name":"widget_sow-editor","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":1,"cell":0,"id":4,"widget_id":"038c9ef2-3ae5-44c6-bea0-db4d02ad99f5","style":{"background_display":"tile","big_widget_title":true,"small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Ask a Question","text":"<p>[contact-form-7 id=\"7235\" title=\"Got a Question\"]</p>","text_selected_editor":"tmce","autop":true,"id":"sow-editor-5510005","option_name":"widget_sow-editor","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":1,"cell":1,"id":5,"widget_id":"b5280ed3-e205-4b11-80fb-269ee0ce45ef","style":{"background_display":"tile","big_widget_title":true,"small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Our Advantages","text":"","text_selected_editor":"tinymce","autop":true,"_sow_form_id":"13879382515bd0f35e93335108200211","_sow_form_timestamp":"1540420456036","id":"sow-editor-5510006","option_name":"widget_sow-editor","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":2,"cell":0,"id":6,"widget_id":"9873bdf3-8a83-42ba-9263-53963ef5047b","style":{"background_image_attachment":false,"background_display":"tile","big_widget_title":true,"small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Personalized Treatment","text":"You will receive a full individualized treatment","link":"","icon":"fa-medkit","layout":"big","id":"qt_icon_box-5510007","option_name":"widget_qt_icon_box","panels_info":{"class":"QT_Icon_Box","raw":false,"grid":3,"cell":0,"id":7,"widget_id":"b02fba86-1a72-467a-a8d5-b25baef15901","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Comfortable Clinic","text":"Our clinic feels like a comfortable health & fitness center","link":"","icon":"fa-building-o","id":"qt_icon_box-5510008","option_name":"widget_qt_icon_box","panels_info":{"class":"QT_Icon_Box","raw":false,"grid":3,"cell":0,"id":8,"widget_id":"5f9b7620-bd1f-4aee-a7ba-a1892a8d8d0f","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Licensed Therapists","text":"Your treatment will be performed by only licensed therapists","link":"","icon":"fa-check","id":"qt_icon_box-5510009","option_name":"widget_qt_icon_box","panels_info":{"class":"QT_Icon_Box","raw":false,"grid":3,"cell":1,"id":9,"widget_id":"e104e11e-60c6-4d3d-911c-725af47f4bca","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Practitioners Network","text":"We will work closely with all your health practitioners","link":"","icon":"fa-users","layout":"big","id":"qt_icon_box-5510010","option_name":"widget_qt_icon_box","panels_info":{"class":"QT_Icon_Box","raw":false,"grid":3,"cell":1,"id":10,"widget_id":"491a4b0b-2a97-4e52-84fc-7f6cda49e4e3","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Experience Staff","text":"Our therapists are trained and certified in therapy technique","link":"","icon":"fa-graduation-cap","id":"qt_icon_box-5510011","option_name":"widget_qt_icon_box","panels_info":{"class":"QT_Icon_Box","raw":false,"grid":3,"cell":2,"id":11,"widget_id":"98baa750-b8b9-4eba-bf59-8540f0fef8b1","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Therapy Goals","text":"Setting goals is the best way to enjoy a successful outcome","link":"","icon":"fa-check-circle-o","id":"qt_icon_box-5510012","option_name":"widget_qt_icon_box","panels_info":{"class":"QT_Icon_Box","raw":false,"grid":3,"cell":2,"id":12,"widget_id":"0e6ab868-6402-456d-97a2-183e268927a0","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Meet the Team","text":"","text_selected_editor":"tinymce","autop":true,"_sow_form_id":"5691340d36688","id":"sow-editor-5510013","option_name":"widget_sow-editor","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":4,"cell":0,"id":13,"widget_id":"0703470a-4b66-4b96-9219-8c18d9bd80ea","style":{"background_display":"tile","big_widget_title":true,"small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Robert Davis","person_tag":"Physical Therapist","person_description":"I started practicing in 1999 after graduating from the University of Vermont. During those college class years...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"http://www.facebook.com/qreativethemes","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"#","person_link_text":"Read More","id":"qt_team_member-5510014","option_name":"widget_qt_team_member","panels_info":{"class":"QT_Team_Member","raw":false,"grid":5,"cell":0,"id":14,"widget_id":"702d773a-b721-4ec5-8bcd-c91e55c29d9f","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Helen Wilmore","person_tag":"Massage Therapist","person_description":"I chose a physical therapy career because I knew I wanted to help people without sticking them with needles...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"http://www.facebook.com/qreativethemes","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"#","person_link_text":"Read More","id":"qt_team_member-5510015","option_name":"widget_qt_team_member","panels_info":{"class":"QT_Team_Member","raw":false,"grid":5,"cell":1,"id":15,"widget_id":"be6b1fe7-04fd-491a-937d-363e3c8af247","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Kristina Castle","person_tag":"Physical Therapist","person_description":"As a physical therapist I have the opportunity on a daily basis to improve the lives of my patients by identifying...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"http://www.facebook.com/qreativethemes","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"#","person_link_text":"Read More","id":"qt_team_member-5510016","option_name":"widget_qt_team_member","panels_info":{"class":"QT_Team_Member","raw":false,"grid":5,"cell":2,"id":16,"widget_id":"cdd006b2-05cd-4cdf-a2f0-1504d3b45a92","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Anthony Wills","person_tag":"Chiropractor","person_description":"I also had a running injury when I was in high school and had to go to PT. I thought “This is what I want...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"http://www.facebook.com/qreativethemes","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"#","person_link_text":"Read More","id":"qt_team_member-5510017","option_name":"widget_qt_team_member","panels_info":{"class":"QT_Team_Member","raw":false,"grid":5,"cell":3,"id":17,"widget_id":"0188dbe4-fa02-4ef6-9cdf-0e9493c86545","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"No matter whether your condition was caused by a sport, work <br> accident or otherwise, we welcome the chance to serve you.","title_color":"","subtitle":"","subtitle_color":"","buttons":"[button href=\"#\" style=\"outline\"]Schedule an Appointment[/button]","layout":"cta-block","id":"qt_call_to_action-5510018","option_name":"widget_qt_call_to_action","panels_info":{"class":"QT_Call_To_Action","raw":false,"grid":6,"cell":0,"id":18,"widget_id":"25aad70f-99d5-4ce8-b8d0-590b0192381f","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Latest News and Research","text":"<p>Find out the latest news about our Physiotherapy Clinic and information about all your Physiotherapy and health related needs. </p><p>We are always happy to hear what you have to say so be sure to leave a comment.</p><p>[button href=\"#\"]Read all News[/button]</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56a7fab14f58c","id":"sow-editor-5510019","option_name":"widget_sow-editor","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":7,"cell":0,"id":19,"widget_id":"6e1ab979-eca3-4e6d-8dff-cdc35355781a","style":{"widget_css":"margin-top: 15px;","background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","categories":"-1","count":3,"columns":3,"sticky":"","more_text":"","more_text_post":"","page_id":0,"id":"qt_recent_posts_block-5510020","option_name":"widget_qt_recent_posts_block","panels_info":{"class":"QT_Recent_Posts_Block","raw":false,"grid":7,"cell":1,"id":20,"widget_id":"0b26e098-4474-4d10-8fbb-2de337fc7383","style":{"background_display":"tile","big_widget_title":true,"small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"map_center":"New York","settings":{"map_type":"interactive","width":"640","height":"370","zoom":12,"draggable":true,"so_field_container_state":"open","scroll_zoom":false,"disable_default_ui":false,"keep_centered":false},"markers":{"marker_icon":0,"marker_positions":[{"place":"New York","info":"","info_selected_editor":"tinymce","info_max_width":""},{"place":"Jersey City","info":"","info_selected_editor":"tinymce","info_max_width":""}],"info_display":"click","so_field_container_state":"closed","marker_at_center":false,"markers_draggable":false},"styles":{"style_method":"raw_json","styled_map_name":"","raw_json_map_styles":"[{\"featureType\":\"landscape\",\"stylers\":[{\"saturation\":-100},{\"lightness\":60}]},{\"featureType\":\"road.local\",\"stylers\":[{\"saturation\":-100},{\"lightness\":40},{\"visibility\":\"on\"}]},{\"featureType\":\"transit\",\"stylers\":[{\"saturation\":-100},{\"visibility\":\"simplified\"}]},{\"featureType\":\"administrative.province\",\"stylers\":[{\"visibility\":\"off\"}]},{\"featureType\":\"water\",\"stylers\":[{\"visibility\":\"on\"},{\"lightness\":30}]},{\"featureType\":\"road.highway\",\"elementType\":\"geometry.fill\",\"stylers\":[{\"color\":\"#ef8c25\"},{\"lightness\":40}]},{\"featureType\":\"road.highway\",\"elementType\":\"geometry.stroke\",\"stylers\":[{\"visibility\":\"off\"}]},{\"featureType\":\"poi.park\",\"elementType\":\"geometry.fill\",\"stylers\":[{\"color\":\"#b6c54c\"},{\"lightness\":40},{\"saturation\":-40}]},{}]","so_field_container_state":"closed","custom_map_styles":[]},"directions":{"origin":"","destination":"","travel_mode":"driving","so_field_container_state":"closed","avoid_highways":false,"avoid_tolls":false,"waypoints":[],"optimize_waypoints":false},"api_key_section":{"api_key":"","so_field_container_state":"closed"},"_sow_form_id":"56b0bbf69a77a","id":"sow-google-map-5510021","option_name":"widget_sow-google-map","panels_info":{"class":"SiteOrigin_Widget_GoogleMap_Widget","raw":false,"grid":8,"cell":0,"id":21,"widget_id":"c87f5859-9f53-4d69-8a16-f0a2c35cd6d2","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Client Testimonials","columns":"2","autocycle":"no","interval":6000,"testimonials":{"1":{"id":"1","quote":"My physical therapist is excellent! The whole office is very friendly and helpful. Physio is absolutely outstanding. Thank you very much for your great, attentive service","author":"Jennifer Ebron","description":"Neck Pain Treatment"},"2":{"id":"2","quote":"All of the staff was fantastic! The care I received was impeccable. Great place! I also love the availability of the Fit Plan for continued support after my discharge","author":"Christopher Strock","description":"Back Pain Treatment"},"3":{"id":"3","quote":"Everyone I worked with was wonderful, very professional, caring and prompt. My therapist was great, as were all of the aids!","author":"John White","description":"Work Injury Treatment"},"4":{"id":"4","quote":"I had a really positive experience and my shoulder is totally functional again, without pain! I really enjoyed my therapist and all of the rest of the staff","author":"Kimberly Rogers","description":"Sport Injury Treatment"}},"id":"qt_testimonials-5510022","option_name":"widget_qt_testimonials","panels_info":{"class":"QT_Testimonials","raw":false,"grid":9,"cell":0,"id":22,"widget_id":"64dfd572-d4ac-4b9c-bfb1-6fda7c9391f3","style":{"background_display":"tile","big_widget_title":true,"small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Accepted Insurances","text":"","text_selected_editor":"tinymce","autop":true,"_sow_form_id":"15999430475bd0f422a11f0468416820","_sow_form_timestamp":"1540420652845","id":"sow-editor-5510023","option_name":"widget_sow-editor","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":10,"cell":0,"id":23,"widget_id":"8d45a1bf-6a00-43ad-afac-4b39842acdd5","style":{"background_image_attachment":false,"background_display":"tile","margin":"15px 0px 0px 0px","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","content":"<div class=\"client-logos\">\n\t<div class=\"logo\">\n\t\t<img src=\"http://export-xml.qreativethemes.com/physio/wp-content/themes/physio-qt/assets/images/insurance_1.jpg\" alt=\"Insurance 1\">\n\t</div>\n\t<div class=\"logo\">\n\t\t<img src=\"http://export-xml.qreativethemes.com/physio/wp-content/themes/physio-qt/assets/images/insurance_3.jpg\" alt=\"Insurance 2\">\n\t</div>\n\t<div class=\"logo\">\n\t\t<img src=\"http://export-xml.qreativethemes.com/physio/wp-content/themes/physio-qt/assets/images/insurance_4.jpg\" alt=\"Insurance 3\">\n\t</div>\n\t<div class=\"logo\">\n\t\t<img src=\"http://export-xml.qreativethemes.com/physio/wp-content/themes/physio-qt/assets/images/insurance_2.jpg\" alt=\"Insurance 4\">\n\t</div>\n</div>","id":"custom_html-5510024","option_name":"widget_custom_html","panels_info":{"class":"WP_Widget_Custom_HTML","raw":false,"grid":10,"cell":1,"id":24,"widget_id":"31f9f1f9-1e51-4f02-957c-5460311d6a72","style":{"background_image_attachment":false,"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}}],"grids":[{"cells":4,"style":{"background_display":"tile","bottom_margin":"70px"}},{"cells":2,"style":{"padding":"70px","background":"#f5f8fb","background_display":"cover","bottom_margin":"70px","row_stretch":"full"}},{"cells":1,"style":{"background_display":"tile","bottom_margin":"10px"}},{"cells":3,"style":{"background_display":"tile","bottom_margin":"70px"}},{"cells":1,"style":{"background_display":"tile","bottom_margin":"10px"}},{"cells":4,"style":{"background_display":"tile","bottom_margin":"70px"}},{"cells":1,"style":{"row_css":"background-position: center bottom;","padding":"90px","background":"#cecece","background_display":"tile","bottom_margin":"0px","row_stretch":"full"}},{"cells":2,"style":{"padding":"80px","background_display":"tile","bottom_margin":"0px","row_stretch":"full"}},{"cells":1,"style":{"background_display":"tile","bottom_margin":"0px","row_stretch":"full-stretched"}},{"cells":1,"style":{"padding":"75px","background":"#f5f8fb","background_display":"tile","bottom_margin":"85px","row_stretch":"full"}},{"cells":2,"style":{"background_display":"tile","bottom_margin":"0px"}}],"grid_cells":[{"grid":0,"index":0,"weight":0.25,"style":[]},{"grid":0,"index":1,"weight":0.25,"style":[]},{"grid":0,"index":2,"weight":0.25,"style":[]},{"grid":0,"index":3,"weight":0.25,"style":[]},{"grid":1,"index":0,"weight":0.5,"style":[]},{"grid":1,"index":1,"weight":0.5,"style":[]},{"grid":2,"index":0,"weight":1,"style":[]},{"grid":3,"index":0,"weight":0.33333333333333,"style":[]},{"grid":3,"index":1,"weight":0.33333333333333,"style":[]},{"grid":3,"index":2,"weight":0.33333333333333,"style":[]},{"grid":4,"index":0,"weight":1,"style":[]},{"grid":5,"index":0,"weight":0.25,"style":[]},{"grid":5,"index":1,"weight":0.25,"style":[]},{"grid":5,"index":2,"weight":0.25,"style":[]},{"grid":5,"index":3,"weight":0.25,"style":[]},{"grid":6,"index":0,"weight":1,"style":[]},{"grid":7,"index":0,"weight":0.25,"style":[]},{"grid":7,"index":1,"weight":0.75,"style":[]},{"grid":8,"index":0,"weight":1,"style":[]},{"grid":9,"index":0,"weight":1,"style":[]},{"grid":10,"index":0,"weight":0.37,"style":[]},{"grid":10,"index":1,"weight":0.63,"style":[]}]}', true )
        );

        $layouts['about-us'] = array_merge(
            array(
                'name'          => esc_html__( 'About Us', 'physio-qt' ),
                'screenshot'    => get_theme_file_uri( '/assets/images/pre-built/about-us.png' ),
            ),
            json_decode( '{"widgets":[{"title":"Our Vision","text":"<p>To be a company that attracts, rewards, and retains highly skilled physical therapy staff. Our proactive approach to the development of best business practices and promotion of effective treatment methods will help us accomplish this.</p>","text_selected_editor":"tinymce","autop":true,"_sow_form_id":"568fd904c990e","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":0,"id":0,"widget_id":"857f886e-667f-4f63-9053-aa21a2f2bd12","style":{"background_image_attachment":false,"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Our Philosophy","text":"<p>Physio Physical Therapy is committed to providing high quality outpatient physical therapy services in beautiful state-of-the-art facilities.</p><p>As a healthcare leader we partner with groups and events within the communities we serve. Our focus on our physical therapists continuing education is unmatched and guarantees our physical therapists understand and put into practice cutting-edge treatments and rehabilitation techniques available for all types of injuries and conditions.</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"568fd902dec0f","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":0,"id":1,"widget_id":"5b97d2ea-b320-4036-aec1-5161f92c1881","style":{"background_image_attachment":false,"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Our Mission","text":"<p>We are committed as primary healthcare professionals to help our clients resume their lifelong pursuit of health, fitness, and well-being.</p><p><span style=\"color: #56afd5; font-size: 15px;\"><strong>High Quality</strong></span></p><p>We take a goal-oriented approach to healing. Whatever your goals might be we want to help you achieve them</p><p><span style=\"color: #56afd5; font-size: 15px;\"><strong>Patient Care</strong></span></p><p>We’ll provide hands-on treatment in the office and education you can take home with you, enabling you to become an active participant in your recovery and future physical health.</p><p><span style=\"color: #56afd5; font-size: 15px;\"><strong>Professional Service</strong></span></p><p>Our five physical therapists have a combined 120 years of clinical experience and a shared passion for helping our community stay active.</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"568fd90295f02","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":1,"id":2,"widget_id":"7cfeb8a0-3f9d-4a61-883a-29c7a495bbbb","style":{"background_image_attachment":false,"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<p><a href=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/360x508.png\" rel=\"attachment wp-att-7477\"><img class=\"alignnone size-full wp-image-7477\" src=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/360x508.png\" alt=\"360x508\" width=\"360\" height=\"508\" /></a></p>","text_selected_editor":"tinymce","autop":true,"_sow_form_id":"568fd90567b41","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":2,"id":3,"widget_id":"86845edc-fad6-4c21-a26c-7c15244fde04","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<p><img class=\"size-full wp-image-245\" src=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/image-divider.jpg\" alt=\"image-divider\" width=\"1144\" height=\"50\" /></p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"568fd85e4edcd","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":1,"cell":0,"id":4,"widget_id":"7cb46f92-a2a9-4857-82f6-7d36e929b438","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Our Therapists","text":"","filter":false,"panels_info":{"class":"WP_Widget_Text","raw":false,"grid":2,"cell":0,"id":5,"widget_id":"73074131-bac7-4626-9d62-799f52bc9d12","style":{"background_image_attachment":false,"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Robert Davis","person_tag":"Physical Therapist","person_description":"I started practicing in 1999 after graduating from the University of Vermont. During those college class years...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"#","person_link_text":"Read More","panels_info":{"class":"QT_Team_Member","raw":false,"grid":3,"cell":0,"id":6,"widget_id":"e726f1fe-26b1-4246-b8e5-412b50d262f1","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Helen Wilmore","person_tag":"Massage Therapist","person_description":"I chose a physical therapy career because I knew I wanted to help people without sticking them with needles...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"#","person_link_text":"Read More","panels_info":{"class":"QT_Team_Member","raw":false,"grid":3,"cell":1,"id":7,"widget_id":"877143ad-43a4-4b93-81e5-820ae81f4def","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Kristina Castle","person_tag":"Physical Therapist","person_description":"As a physical therapist I have the opportunity on a daily basis to improve the lives of my patients by identifying...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"#","person_link_text":"Read More","panels_info":{"class":"QT_Team_Member","raw":false,"grid":3,"cell":2,"id":8,"widget_id":"5dc2a4a7-1b03-49c4-923e-c1d1e463923b","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Anthony Wills","person_tag":"Chiropractor","person_description":"I also had a running injury when I was in high school and had to go to PT. I thought “This is what I want...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"#","person_link_text":"Read More","panels_info":{"class":"QT_Team_Member","raw":false,"grid":3,"cell":3,"id":9,"widget_id":"97c01a7c-6b92-4eb2-a0da-f3fc10395a22","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Bernard Vance","person_tag":"Assistant PT","person_description":"I chose a physical therapy career because I knew I wanted to help people without sticking them with needles...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"","person_link_text":"","panels_info":{"class":"QT_Team_Member","raw":false,"grid":4,"cell":0,"id":10,"widget_id":"37993e89-697b-4bb6-a98a-7c2f38aa06c8","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Alex Mitchell","person_tag":"Assistant PT","person_description":"I chose a physical therapy career because I knew I wanted to help people without sticking them with needles...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"","person_link_text":"","panels_info":{"class":"QT_Team_Member","raw":false,"grid":4,"cell":1,"id":11,"widget_id":"ce73d15c-7168-4936-a167-9a1a5333ac30","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Andrea Pitts","person_tag":"Office Manager","person_description":"I chose a physical therapy career because I knew I wanted to help people without sticking them with needles...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"","person_link_text":"","panels_info":{"class":"QT_Team_Member","raw":false,"grid":4,"cell":2,"id":12,"widget_id":"f17034ee-ce20-4d1d-8be2-afddfefceea8","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"We\'re hiring Therapists","text":"<p>If you\'re a Physical therapist looking to take your career to the next level, explore all the Physical Therapy career opportunities.</p><p>We’re looking for candidates who are ready to bring their expertise to our team and strive to provide the very best service to our clients.</p><p><a class=\"text-link\" href=\"#\">See all Careers</a></p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56a8c2efe4548","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":4,"cell":3,"id":13,"widget_id":"761a6826-8f06-46be-9658-ec8603c075a6","style":{"background_display":"tile","big_widget_title":"","small_widget_title":true,"white_widget_title":true,"featured_box":true,"white_featured_box":""}}}],"grids":[{"cells":3,"style":{"bottom_margin":"40px","background_display":"tile"}},{"cells":1,"style":{"bottom_margin":"10px","background_display":"tile"}},{"cells":1,"style":{"bottom_margin":"10px","background_display":"tile"}},{"cells":4,"style":{"bottom_margin":"35px","background_display":"tile"}},{"cells":4,"style":{"background_display":"tile"}}],"grid_cells":[{"grid":0,"index":0,"weight":0.33333333333333,"style":{}},{"grid":0,"index":1,"weight":0.33333333333333,"style":{}},{"grid":0,"index":2,"weight":0.33333333333333,"style":{}},{"grid":1,"index":0,"weight":1,"style":{}},{"grid":2,"index":0,"weight":1,"style":{}},{"grid":3,"index":0,"weight":0.25,"style":{}},{"grid":3,"index":1,"weight":0.25,"style":{}},{"grid":3,"index":2,"weight":0.25,"style":{}},{"grid":3,"index":3,"weight":0.25,"style":{}},{"grid":4,"index":0,"weight":0.25,"style":{}},{"grid":4,"index":1,"weight":0.25,"style":{}},{"grid":4,"index":2,"weight":0.25,"style":{}},{"grid":4,"index":3,"weight":0.25,"style":{}}],"name":"About Us"}', true )
        );

		$layouts['careers'] = array_merge(
            array(
                'name'          => esc_html__( 'Careers', 'physio-qt' ),
                'screenshot'    => get_theme_file_uri( '/assets/images/pre-built/careers.png' ),
            ),
            json_decode( '{"widgets":[{"title":"","text":"<p>As the industry leader Physio isn\'t your ordinary therapy company. We set ourselves apart by rolling out the red carpet for every patient, every day. We employ the brightest individuals to achieve our mission. We are currently seeking candidates for physical therapist jobs, physical therapy clinic staff, hand therapy jobs, sports medicine jobs, athletic training jobs, and corporate roles. We invite you to browse our openings and apply online today!</p>","text_selected_editor":"tinymce","autop":true,"_sow_form_id":"5693b54ee7e20","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":0,"id":0,"widget_id":"40abe3be-9c86-4f82-9ad9-f24b1358249e","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<p>[collapsibles]<br /> [collapse title=\"Physical Therapist (Assistent)\" state=\"active\"]</p><p>The Physical Therapist is a member of the home care team who provides rehabilitation care to the clients as requested by the client and, when required, as prescribed by the physician and in compliance with applicable laws and regulations and the policies of the Agency.</p><p> </p><ol><li>Possesses a degree from a baccalaureate or masters program in physical therapy approved by an accredited organization.</li><li>Is licensed to practice as physical therapist within the State of Oklahoma.</li><li>Has at least two years of appropriate experience as a physical therapist. Community/home health experience is preferred.</li><li>Complies with accepted professional standards and practice.</li><li>Possesses and maintains good physical stamina and mental health. Has presented a preemployment screening including a negative TB skin test and/or CXR and other tests as required by the Agency.</li><li>Possesses and maintains current CPR certification.</li></ol><p> </p><p><a class=\"text-link\" href=\"#\">Apply for this Job</a></p><p>[/collapse]</p><p>[collapse title=\"Physical Therapist Rehabilitation\"]</p><p>The Physical Therapist is a member of the home care team who provides rehabilitation care to the clients as requested by the client and, when required, as prescribed by the physician and in compliance with applicable laws and regulations and the policies of the Agency.</p><p> </p><ol><li>Possesses a degree from a baccalaureate or masters program in physical therapy approved by an accredited organization.</li><li>Is licensed to practice as physical therapist within the State of Oklahoma.</li><li>Has at least two years of appropriate experience as a physical therapist. Community/home health experience is preferred.</li><li>Complies with accepted professional standards and practice.</li><li>Possesses and maintains good physical stamina and mental health. Has presented a preemployment screening including a negative TB skin test and/or CXR and other tests as required by the Agency.</li><li>Possesses and maintains current CPR certification.</li></ol><p> </p><p><a class=\"text-link\" href=\"#\">Apply for this Job</a></p><p>[/collapse]</p><p>[collapse title=\"Office Manager\"]</p><p>The Physical Therapist is a member of the home care team who provides rehabilitation care to the clients as requested by the client and, when required, as prescribed by the physician and in compliance with applicable laws and regulations and the policies of the Agency.</p><p> </p><ol><li>Possesses a degree from a baccalaureate or masters program in physical therapy approved by an accredited organization.</li><li>Is licensed to practice as physical therapist within the State of Oklahoma.</li><li>Has at least two years of appropriate experience as a physical therapist. Community/home health experience is preferred.</li><li>Complies with accepted professional standards and practice.</li><li>Possesses and maintains good physical stamina and mental health. Has presented a preemployment screening including a negative TB skin test and/or CXR and other tests as required by the Agency.</li><li>Possesses and maintains current CPR certification.</li></ol><p> </p><p><a class=\"text-link\" href=\"#\">Apply for this Job</a></p><p>[/collapse]<br /> [/collapsibles]</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"568ad6cc187d5","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":0,"id":1,"widget_id":"da2bfc30-73b1-42eb-b983-8192e21013be","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}}],"grids":[{"cells":1,"style":[]}],"grid_cells":[{"grid":0,"index":0,"weight":1,"style":[]}],"name":"Careers"}', true )
        );

		$layouts['faq'] = array_merge(
            array(
                'name'          => esc_html__( 'Faq', 'physio-qt' ),
                'screenshot'    => get_theme_file_uri( '/assets/images/pre-built/faq-page.png' ),
            ),
            json_decode( '{"widgets":[{"title":"","text":"<h4>What is a Physiotherapist?</h4><p>Physiotherapists are university trained and are experts in injury diagnosis, injury treatment, exercise prescription, injury prevention, rehabilitation and many other areas of sport and health and fitness.</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56a22fd9532df","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":0,"id":0,"widget_id":"4f059a8f-f559-4d87-8857-78e57f625328","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<h4>What do I need to bring?</h4><p>Be prepared to provide your previous medical or surgical history. If you have them and if they are relevant bring scan/MRI reports, and list of medication. You may wish to bring shorts and t-shirt.</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56a22e85196e9","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":1,"id":1,"widget_id":"b6d6aa5e-3b90-40ad-b633-5336f1053a49","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<h4>How many visits will I need?</h4><p>The number of treatments will vary depending on the problem and individual. After a thorough assessment, the physiotherapist will discuss their treatment plan for the rehabilitation process.</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56a22fdbb7667","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":2,"id":2,"widget_id":"b4af143d-fa25-4c30-a818-7d7efb696d65","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<h4><strong class=\"question\">What should I wear to my appointment?</strong></h4><p>If we are treating your feet you will not be asked to undress but if we are treating your spine, you will be so comfortable and modest underwear or even a pair of shorts is appropriate.</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56a91e7822e4d","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":1,"cell":0,"id":3,"widget_id":"46a57b7c-2540-4fc0-b627-9826875aaed8","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<h4><strong class=\"question\">How do I make an appointment?</strong></h4><p>You can get in touch by phone <span class=\"icon-box--description\">( +123 - 456 -7890 </span>) or use the form under the contact page. Alternatively use the quick and easy <a href=\"#\">online booking</a> page, which is the method we prefer.</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56a91ec979c7a","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":1,"cell":1,"id":4,"widget_id":"3154e91b-ad7a-4a11-a59e-2d68645eb3ec","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<h4>Do I have to be referred by a doctor?</h4><p>No, physiotherapists can assess and treat without referral by a doctor. However most health insurers require a doctors referral before they authorise cover of fees, some only require a phone call.</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56a923b793c35","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":1,"cell":2,"id":5,"widget_id":"f61cb15c-382c-43b6-872b-a5a793c31122","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<p>[collapsibles]</p><p>[collapse title=\"How long will I need physical therapy?\" state=\"active\"]</p><p>Treatment duration depends on your diagnosis, the severity of your impairments, your past medical history, and other factors.  Re-evaluations will be done to assess your progress and your therapist communicates with your physician to help you achieve your therapy goals.</p><p>[/collapse]</p><p>[collapse title=\"What conditions does physical therapy treat?\"]</p><p>We sees and treats patient for a wide range of conditions and diagnoses.  Please visit our <a href=\"#\">Services</a> for an extensive list of conditions and diagnoses we see patients for.</p><p>[/collapse]</p><p>[collapse title=\"Are there physical therapist specialists?\"]</p><p>Physical Therapy at Physio is proud to have 20 physical and occupational therapists on staff who have obtained and achieved advanced certifications in orthopedics, sports, hand therapy, manual therapy, and pedorthics.</p><p>[/collapse]</p><p>[collapse title=\"How do I know if my insurance covers physical therapy services?\"]</p><p>We will check with your health insurance provide to determine if outpatient physical therapy services are covered under your plan. We recommend that you confirm  your insurance coverage.</p><p>[/collapse]</p><p>[collapse title=\"How do I cancel or reschedule my appointment(s)?\"]</p><p>Call the facility in which you go to for all your regular appointments.  You may also call our administration office at + 123 556 7890.</p><p>[/collapse]</p><p>[/collapsibles]</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"568bf101c18b0","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":2,"cell":0,"id":6,"widget_id":"89d698a2-61ba-4ee0-b325-27a18d4fedd7","style":{"background_display":"tile","big_widget_title":"","small_widget_title":true,"white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Ask us a Question","text":"<p>Feel free to ask any physical therapy related questions over the phone, or get send your question via this form below. Your message will be dispatched directly to our staff who will answer as soon as they can.</p><p> </p><p><br /> [contact-form-7 id=\"7235\" title=\"Got a Question\"]</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56a66922d6183","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":3,"cell":0,"id":7,"widget_id":"242c4a41-715c-4540-8044-70f93d4152c9","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}}],"grids":[{"cells":3,"style":{"background_display":"tile","bottom_margin":"50px","gutter":"40px"}},{"cells":3,"style":{"background_display":"tile","bottom_margin":"70px","gutter":"40px"}},{"cells":1,"style":{"background_display":"tile","bottom_margin":"50px"}},{"cells":1,"style":{"padding":"50px","background":"#f5f8fb","background_display":"tile","cell_class":"text-center"}}],"grid_cells":[{"grid":0,"index":0,"weight":0.33333333333333,"style":[]},{"grid":0,"index":1,"weight":0.33333333333333,"style":[]},{"grid":0,"index":2,"weight":0.33333333333333,"style":[]},{"grid":1,"index":0,"weight":0.33333333333333,"style":[]},{"grid":1,"index":1,"weight":0.33333333333333,"style":[]},{"grid":1,"index":2,"weight":0.33333333333333,"style":[]},{"grid":2,"index":0,"weight":1,"style":[]},{"grid":3,"index":0,"weight":1,"style":[]}],"name":"FAQ Page"}', true )
        );

        $layouts['single-location'] = array_merge(
            array(
                'name'          => esc_html__( 'Single Location', 'physio-qt' ),
                'screenshot'    => get_theme_file_uri( '/assets/images/pre-built/single-location.png' ),
            ),
            json_decode( '{"widgets":[{"title":"","text":"<p><strong>Clinic Address<br /> </strong><span style=\"line-height: 1.5;\">1600 Amphitheatre Parkway<br /> </span><span style=\"line-height: 1.5;\">Mountain View CA 94043<br /> </span><span style=\"line-height: 1.5;\">United States</span></p><hr /><p><strong>Phone Number<br /> </strong>+ (123) 123 - 354 - 923</p><hr /><p><strong>Email Address<br /></strong>jerseycity@physiotherapy.com</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"568d27abc024a","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":0,"id":0,"widget_id":"918c1613-623f-4d83-b343-3b278d96e83f","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":true,"white_featured_box":""}}},{"title":"","brochure_icon":"fa-download","brochure_url":"#","brochure_btn":"All Location Details","new_tab":"","panels_info":{"class":"QT_Brochure","raw":false,"grid":0,"cell":0,"id":1,"widget_id":"ad390ade-7bc7-48be-a404-48e44fc8be01","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"map_center":"Jersey City","settings":{"map_type":"interactive","width":"640","height":"420","zoom":15,"draggable":true,"so_field_container_state":"open","scroll_zoom":false,"disable_default_ui":false,"keep_centered":false},"markers":{"marker_at_center":true,"marker_icon":0,"marker_positions":[{"place":"Jersey City","info":"<p>This is the Jersey City location</p>","info_selected_editor":"tinymce","info_max_width":""}],"info_display":"click","so_field_container_state":"open","markers_draggable":false},"styles":{"style_method":"normal","styled_map_name":"","raw_json_map_styles":"","so_field_container_state":"closed","custom_map_styles":[]},"directions":{"origin":"","destination":"","travel_mode":"driving","so_field_container_state":"closed","avoid_highways":false,"avoid_tolls":false,"waypoints":[],"optimize_waypoints":false},"api_key_section":{"api_key":"","so_field_container_state":"closed"},"_sow_form_id":"568d27c67bfa5","panels_info":{"class":"SiteOrigin_Widget_GoogleMap_Widget","raw":false,"grid":0,"cell":1,"id":2,"widget_id":"5f463ba8-8dd7-4496-bc58-066abaf5f380","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Location Therapists","text":"","filter":false,"panels_info":{"class":"WP_Widget_Text","raw":false,"grid":1,"cell":0,"id":3,"widget_id":"6cb4e41d-07ca-4ea3-872a-c19d2a667a1e","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Robert Davis","person_tag":"Physical Therapist","person_description":"I started practicing in 1999 after graduating from the University of Vermont. During those college class years...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"","person_link_text":"","panels_info":{"class":"QT_Team_Member","raw":false,"grid":2,"cell":0,"id":4,"widget_id":"4446309c-58f8-48e1-9856-8e793a65e229","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Helen Wilmore","person_tag":"Massage Therapist","person_description":"I chose a physical therapy career because I knew I wanted to help people without sticking them with needles...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"","person_link_text":"","panels_info":{"class":"QT_Team_Member","raw":false,"grid":2,"cell":1,"id":5,"widget_id":"0a9841af-2ba2-42ed-b1cb-84b35a03ed60","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Kristina Castle","person_tag":"Physical Therapist","person_description":"As a physical therapist I have the opportunity on a daily basis to improve the lives of my patients by identifying...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"","person_link_text":"","panels_info":{"class":"QT_Team_Member","raw":false,"grid":2,"cell":2,"id":6,"widget_id":"4f1a53d3-23ca-4acf-ab4a-77106c1c7fae","style":{"background_image_attachment":false,"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"person_name":"Anthony Wills","person_tag":"Chiropractor","person_description":"I also had a running injury when I was in high school and had to go to PT. I thought “This is what I want...","person_image":"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/460x365.png","facebook":"#","twitter":"#","linkedin":"#","email":"#","new_tab":"","person_link_url":"","person_link_text":"","panels_info":{"class":"QT_Team_Member","raw":false,"grid":2,"cell":3,"id":7,"widget_id":"5f6d4447-e385-40f1-b75e-a6b5eeb52214","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}}],"grids":[{"cells":2,"style":{"bottom_margin":"50px","background_display":"tile"}},{"cells":1,"style":{"bottom_margin":"0px","background_display":"tile"}},{"cells":4,"style":{"bottom_margin":"50px","background_display":"tile"}}],"grid_cells":[{"grid":0,"index":0,"weight":0.3,"style":{}},{"grid":0,"index":1,"weight":0.7,"style":{}},{"grid":1,"index":0,"weight":1,"style":{}},{"grid":2,"index":0,"weight":0.25,"style":{}},{"grid":2,"index":1,"weight":0.25,"style":{}},{"grid":2,"index":2,"weight":0.25,"style":{}},{"grid":2,"index":3,"weight":0.25,"style":{}}]}', true )
        );

        $layouts['price-list'] = array_merge(
            array(
                'name'          => esc_html__( 'Price List', 'physio-qt' ),
                'screenshot'    => get_theme_file_uri( '/assets/images/pre-built/price-list.png' ),
            ),
            json_decode( '{"widgets":[{"title":"","text":"<h3>Physical Therapy</h3>\n<table class=\"custom-table\">\n\t<thead>\n\t\t<tr>\n\t\t\t<td>Type</td>\n\t\t\t<td>Session</td>\n\t\t\t<td>Price</td>\n\t\t</tr>\n\t</thead>\n\t<tbody>\n\t\t<tr>\n\t\t\t<td>Evaluation</td>\n\t\t\t<td>60 minutes</td>\n\t\t\t<td>$180</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Follow-up Visit</td>\n\t\t\t<td>45-60 minutes</td>\n\t\t\t<td>$110 per visit</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Extended Follow-up Visit</td>\n\t\t\t<td>60-75 minutes</td>\n\t\t\t<td>$180 per visit</td>\n\t\t</tr>\n\t</tbody>\n</table>","filter":false,"panels_info":{"class":"WP_Widget_Text","raw":false,"grid":0,"cell":0,"id":0,"widget_id":"626979a2-132f-4fdb-bc93-44ff223c1b04","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<h3>Chiropractic Therapy</h3>\n<table class=\"custom-table\">\n\t<thead>\n\t\t<tr>\n\t\t\t<td>Type</td>\n\t\t\t<td>Session</td>\n\t\t\t<td>Price</td>\n\t\t</tr>\n\t</thead>\n\t<tbody>\n\t\t<tr>\n\t\t\t<td>Evaluation</td>\n\t\t\t<td>60 minutes</td>\n\t\t\t<td>$180</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Follow-up Visit</td>\n\t\t\t<td>45-60 minutes</td>\n\t\t\t<td>$110 per visit</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Extended Follow-up Visit</td>\n\t\t\t<td>60-75 minutes</td>\n\t\t\t<td>$180 per visit</td>\n\t\t</tr>\n\t</tbody>\n</table>","filter":false,"panels_info":{"class":"WP_Widget_Text","raw":false,"grid":0,"cell":1,"id":1,"widget_id":"8ee56e6f-c1dd-4ee5-8197-6e99285cd6a3","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<h3>Massage Therapy</h3>\n<table class=\"custom-table\">\n\t<thead>\n\t\t<tr>\n\t\t\t<td>Treatment</td>\n\t\t\t<td>30 min</td>\n            <td>60 min</td>\n            <td>90 min</td>\n\t\t</tr>\n\t</thead>\n\t<tbody>\n\t\t<tr>\n\t\t\t<td>Swedish</td>\n\t\t\t<td>$40</td>\n\t\t\t<td>$60</td>\n\t\t\t<td>$80</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Myofascial Release</td>\n\t\t\t<td>$40</td>\n\t\t\t<td>$60</td>\n\t\t\t<td>$80</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Deep Tissue</td>\n\t\t\t<td>$40</td>\n\t\t\t<td>$60</td>\n\t\t\t<td>$80</td>\n\t\t</tr>\n        <tr>\n\t\t\t<td>Sports Massage</td>\n\t\t\t<td>$40</td>\n\t\t\t<td>$60</td>\n\t\t\t<td>$80</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Prenatal Massage</td>\n\t\t\t<td>$40</td>\n\t\t\t<td>$60</td>\n\t\t\t<td>$80</td>\n\t\t</tr>\n\t</tbody>\n</table>","filter":false,"panels_info":{"class":"WP_Widget_Text","raw":false,"grid":1,"cell":0,"id":2,"widget_id":"6bc077a2-f7b5-4c88-8657-1670e1004805","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Additional Information","text":"<p>We are a small, fee-for-service clinic, meaning that we collect payment at the time of service (cash, credit card, check, flexible savings accounts and health savings accounts). After each session we will email an itemized bill to our patients so those who are interested in reimbursement can independently submit it to their insurance companies.</p>","text_selected_editor":"tinymce","autop":true,"_sow_form_id":"568fd7de03efb","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":2,"cell":0,"id":3,"widget_id":"24d06516-13e1-48d9-83fc-b4ceac85de44","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Buy from Shop","text":"<p>[recent_products per_page=\"5\" columns=\"5\"]</p>","text_selected_editor":"tinymce","_sow_form_id":"568fd749270fc","autop":false,"panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":3,"cell":0,"id":4,"widget_id":"45e5fb6e-cab7-4bdd-9ee3-c15d9c97f6d6","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}}],"grids":[{"cells":2,"style":{"bottom_margin":"50px","background_display":"tile"}},{"cells":1,"style":{"bottom_margin":"60px","background_display":"tile"}},{"cells":1,"style":{"bottom_margin":"50px","background_display":"tile"}},{"cells":1,"style":{"bottom_margin":"0px","background_image_attachment":false,"background_display":"tile"}}],"grid_cells":[{"grid":0,"index":0,"weight":0.5,"style":{}},{"grid":0,"index":1,"weight":0.5,"style":{}},{"grid":1,"index":0,"weight":1,"style":{}},{"grid":2,"index":0,"weight":1,"style":{}},{"grid":3,"index":0,"weight":1,"style":{}}],"name":"Price List"}', true )
        );

		$layouts['services'] = array_merge(
            array(
                'name'          => esc_html__( 'Services', 'physio-qt' ),
                'screenshot'    => get_theme_file_uri( '/assets/images/pre-built/services.png' ),
            ),
            json_decode( '{"widgets":[{"page_id":307,"btn_text":"Find out More","panels_info":{"class":"QT_Feature_Page","raw":false,"grid":0,"cell":0,"id":0,"widget_id":"5bce9e77-dabb-43fd-9026-344fc0dce27d","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"page_id":6263,"btn_text":"Find out More","panels_info":{"class":"QT_Feature_Page","raw":false,"grid":0,"cell":1,"id":1,"widget_id":"32cc5edb-95d5-4fd5-bfcc-4a1bb0e92ca4","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"page_id":6266,"btn_text":"Find out More","panels_info":{"class":"QT_Feature_Page","raw":false,"grid":0,"cell":2,"id":2,"widget_id":"2c60740d-c070-4776-8c79-86ff720af180","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"page_id":6393,"btn_text":"Find out More","panels_info":{"class":"QT_Feature_Page","raw":false,"grid":1,"cell":0,"id":3,"widget_id":"17e385c7-c3c0-4909-99e8-c5d47881dd1c","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"page_id":6397,"btn_text":"Find out More","panels_info":{"class":"QT_Feature_Page","raw":false,"grid":1,"cell":1,"id":4,"widget_id":"635677b7-3057-4e22-9df0-1694ed7e0576","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"page_id":6395,"btn_text":"Find out More","panels_info":{"class":"QT_Feature_Page","raw":false,"grid":1,"cell":2,"id":5,"widget_id":"3b1d7636-1482-47e0-b1af-a01315dead61","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}}],"grids":[{"cells":3,"style":{"bottom_margin":"50px","background_display":"tile"}},{"cells":3,"style":{"bottom_margin":"0px","background_image_attachment":false,"background_display":"tile"}}],"grid_cells":[{"grid":0,"index":0,"weight":0.33333333333333,"style":{}},{"grid":0,"index":1,"weight":0.33333333333333,"style":{}},{"grid":0,"index":2,"weight":0.33333333333333,"style":{}},{"grid":1,"index":0,"weight":0.33333333333333,"style":{}},{"grid":1,"index":1,"weight":0.33333333333333,"style":{}},{"grid":1,"index":2,"weight":0.33333333333333,"style":{}}],"name":"Services"}', true )
        );

        $layouts['single-services'] = array_merge(
            array(
                'name'          => esc_html__( 'Single Service', 'physio-qt' ),
                'screenshot'    => get_theme_file_uri( '/assets/images/pre-built/single-service.png' ),
            ),
            json_decode( '{"widgets":[{"title":"","text":"<p><span style=\"font-size: 16px;\">Chiropractic is a non-invasive, hands-on health care discipline that focuses on the neuro-musculoskeletal system. Chiropractors practice a manual approach. Doctors of Chiropractic are specifically trained to detect and correct problems in the spine, often before the patient is even aware they exist.</span></p><hr />","text_selected_editor":"tmce","autop":true,"_sow_form_id":"5693be0fbd3a0","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":0,"id":0,"widget_id":"55424c8a-c848-464e-b126-b4936f56465b","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<p><a href=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\"><img class=\"alignnone wp-image-7481 size-full\" src=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\" alt=\"\" width=\"850\" height=\"567\" /></a><a href=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\" rel=\"attachment wp-att-6991\"><img class=\"alignnone wp-image-7481 size-full\" src=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\" alt=\"\" width=\"850\" height=\"567\" /></a></p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"5693cc3943fbd","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":1,"cell":0,"id":1,"widget_id":"e304c9fa-142e-4342-8fd4-4be900f8978e","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<p><span style=\"color: #56afd5; font-size: 15px;\"><strong>What is Wellness Chiropractic?</strong></span></p><p>More often than not, when we tell someone that we are a chiropractic office, they immediately associate our vocation with neck and/or back pain. What many do not realize, however, is that chiropractic is a health care modality that provides significantly more than just a solution for pain.</p><p>Chiropractic is a lifestyle that involves all aspects of wellness, including exercise, nutrition, personal development, and stress relief. We have been fortunate to work with people from all walks of life (including newborns, children, and adolescents) and the outcome has been miraculous.</p><p><span style=\"color: #56afd5; font-size: 15px;\"><strong>Speciality Pilates equipment</strong></span></p><p>We use a mix of specialised equipment including Pilates reformers, trapeze tables, fit balls, foam rollers and more. This equipment is designed specifically for clinical Pilates, promoting correct technique, appropriate resistance levels, and targeted exercises so you can really work your key areas and see results. </p><p>Our instructors also spend extra time teaching key muscle contraction techniques, which enables you to get more out of every Pilates workout session.</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"5693cbbe4c491","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":1,"cell":1,"id":2,"widget_id":"463f4665-67ab-4f21-9988-9f6b6fe7be71","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}}],"grids":[{"cells":1,"style":{"background_display":"tile"}},{"cells":2,"style":[]}],"grid_cells":[{"grid":0,"index":0,"weight":1,"style":{}},{"grid":1,"index":0,"weight":0.5,"style":{}},{"grid":1,"index":1,"weight":0.5,"style":{}}]}', true )
        );

        $layouts['single-therapist'] = array_merge(
            array(
                'name'          => esc_html__( 'Single Therapist', 'physio-qt' ),
                'screenshot'    => get_theme_file_uri( '/assets/images/pre-built/single-therapist.png' ),
            ),
            json_decode( '{"widgets":[{"title":"","text":"<p>Kristina opened Physio Physical Therapy in 2006 with the intention of creating a practice that would combine the best of traditional physical therapy with the principles and techniques of osteopathic manual therapy.</p><p>With over 20 years of clinical experience, Kristina\'s practice follows the philosophy that therapy is most successful when people are treated as whole human beings, not as individual parts, and her work is focused on finding and treating the root causes.</p><p><span style=\"color: #56afd5; font-size: 15px;\"><strong>Education</strong></span><br />Kristina, PT, DPT, graduated from Physio University as a Physical Therapist with a Doctorate in Physical Therapy. Kristina has experiences and interest in outpatient orthopedics physical therapy and sport rehabilitation.</p><p><span style=\"color: #56afd5; font-size: 15px;\"><strong>Career</strong></span><br /> Physical therapist at the Hospital, in private practice, and at Physio University. Adjunct faculty member at Physio University and Physical University, teaching both physical therapy and athletic training courses.</p><p><span style=\"color: #56afd5; font-size: 15px;\"><strong>Professional Achievements</strong></span><br />Coordinator of Clinical Education and oversees both the volunteer aide and graduate student intern programs. Member of the International Association of Dance Medicine and Science and has an active interest in the growth of the greater dance medicine community. </p><p><span style=\"color: #56afd5; font-size: 15px;\"><strong>Therapist Qualifications</strong></span></p><p><strong>[fa icon=\"fa-check\"]  </strong>Graduate Diploma in Physical Therapy<br /> <strong>[fa icon=\"fa-check\"]  </strong>Member NZ College of Physiotherapists<br /> <strong>[fa icon=\"fa-check\"]  </strong>Graduate Diploma in Manipulative Therapy<br /> <strong>[fa icon=\"fa-check\"] </strong> Postgraduate Diploma in Rehabilitation<br /> <strong>[fa icon=\"fa-check\"]  </strong>Registered Physiotherapy Acupuncturist</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"568d28b97574f","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":0,"id":0,"widget_id":"9772cff4-f1e8-4833-a66f-24a6cf81630d","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<p><a href=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\" rel=\"attachment wp-att-7481\"><img class=\"alignnone size-full wp-image-7481\" src=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\" alt=\"850x567\" width=\"850\" height=\"567\" /></a><br /> <a href=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\" rel=\"attachment wp-att-7481\"><img class=\"alignnone size-full wp-image-7481\" src=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\" alt=\"850x567\" width=\"850\" height=\"567\" /></a><br /> <a href=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\" rel=\"attachment wp-att-7481\"><img class=\"alignnone size-full wp-image-7481\" src=\"http://export-xml.qreativethemes.com/physio/wp-content/uploads/sites/3/2015/11/850x567.png\" alt=\"850x567\" width=\"850\" height=\"567\" /></a></p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"569e12fd353aa","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":1,"id":1,"widget_id":"c1d534f3-cb33-4c78-a94a-3b8c633721ac","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}}],"grids":[{"cells":2,"style":{"background_display":"tile","bottom_margin":"0px"}}],"grid_cells":[{"grid":0,"index":0,"weight":0.5,"style":[]},{"grid":0,"index":1,"weight":0.5,"style":[]}]}', true )
        );

        $layouts['contact-us'] = array_merge(
            array(
                'name'          => esc_html__( 'Contact Us', 'physio-qt' ),
                'screenshot'    => get_theme_file_uri( '/assets/images/pre-built/contact-us.png' ),
            ),
            json_decode( '{"widgets":[{"title":"","text":"<p><strong>Physio Physical Therapy<br /> </strong><span style=\"line-height: 1.5;\">1600 Amphitheatre Parkway<br /> </span><span style=\"line-height: 1.5;\">Mountain View CA 94043<br /> </span><span style=\"line-height: 1.5;\">United States</span></p><hr /><p><strong>Phone Number<br /> </strong>+ (123) 123 - 354 - 923</p><hr /><p><strong>Email Address<br /> </strong>info@physiotherapy.com</p><hr /><p><strong>Social Media<br /></strong></p><p>[fa icon=\"fa-facebook\" href=\"http://facebook.com/qreativethemes\" target=\"_blank\"]   [fa icon=\"fa-twitter\" href=\"http://twitter.com/qreativethemes\" target=\"_blank\"]   [fa icon=\"fa-linkedin\" href=\"#\"]   [fa icon=\"fa-youtube\" href=\"#\"]   [fa icon=\"fa-instagram\"]</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"568bd6764e89b","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":0,"id":0,"widget_id":"cf46fa26-24ea-4488-b7db-d9530eabe7fe","style":{"background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":true,"white_featured_box":""}}},{"title":"Opening Hours","Monday_from":"07:00","Monday_to":"17:00","Tuesday_from":"07:00","Tuesday_to":"17:00","Wednesday_from":"07:00","Wednesday_to":"17:00","Thursday_from":"07:00","Thursday_to":"17:30","Friday_from":"07:00","Friday_to":"17:00","Saturday_from":"09:00","Saturday_to":"15:00","Sunday_from":"","Sunday_to":"","separator":"-","closed":"CLOSED","highlight":"on","today":"on","extra_info":"","panels_info":{"class":"QT_Opening_Hours","raw":false,"grid":0,"cell":0,"id":1,"widget_id":"b0715ec4-8f56-48a5-85d8-101052cedc7b","style":{"background_display":"tile","big_widget_title":"","small_widget_title":true,"white_widget_title":"","featured_box":"","white_featured_box":""}}},{"map_center":"Paulus Hook","settings":{"map_type":"interactive","width":"640","height":"337","zoom":13,"draggable":true,"so_field_container_state":"closed","scroll_zoom":false,"disable_default_ui":false,"keep_centered":false},"markers":{"marker_icon":0,"marker_positions":[{"place":"Jersey City","info":"<p><strong>Location Jersey City</strong><br />1600 Amphitheatre Parkway<br />Mountain View CA 94043<br />United States<br /><a href=\"#\">Find out More</a></p>","info_selected_editor":"tinymce","info_max_width":""},{"place":"New York","info":"<p><strong>Location New York</strong><br /> 1600 Amphitheatre Parkway<br /> Mountain View CA 94043<br /> United States<br /> <a href=\"#\">Find out More</a></p>","info_selected_editor":"tmce","info_max_width":""}],"info_display":"click","so_field_container_state":"open","marker_at_center":false,"markers_draggable":false},"styles":{"style_method":"raw_json","styled_map_name":"","raw_json_map_styles":"[{\"featureType\":\"landscape\",\"stylers\":[{\"saturation\":-100},{\"lightness\":60}]},{\"featureType\":\"road.local\",\"stylers\":[{\"saturation\":-100},{\"lightness\":40},{\"visibility\":\"on\"}]},{\"featureType\":\"transit\",\"stylers\":[{\"saturation\":-100},{\"visibility\":\"simplified\"}]},{\"featureType\":\"administrative.province\",\"stylers\":[{\"visibility\":\"off\"}]},{\"featureType\":\"water\",\"stylers\":[{\"visibility\":\"on\"},{\"lightness\":30}]},{\"featureType\":\"road.highway\",\"elementType\":\"geometry.fill\",\"stylers\":[{\"color\":\"#ef8c25\"},{\"lightness\":40}]},{\"featureType\":\"road.highway\",\"elementType\":\"geometry.stroke\",\"stylers\":[{\"visibility\":\"off\"}]},{\"featureType\":\"poi.park\",\"elementType\":\"geometry.fill\",\"stylers\":[{\"color\":\"#b6c54c\"},{\"lightness\":40},{\"saturation\":-40}]},{}]","custom_map_styles":[{"map_feature":false,"element_type":"geometry","visibility":true,"color":false}],"so_field_container_state":"open"},"directions":{"origin":"","destination":"","travel_mode":"driving","so_field_container_state":"closed","avoid_highways":false,"avoid_tolls":false,"waypoints":[],"optimize_waypoints":false},"api_key_section":{"api_key":"","so_field_container_state":"closed"},"_sow_form_id":"568c157eb5f13","panels_info":{"class":"SiteOrigin_Widget_GoogleMap_Widget","raw":false,"grid":0,"cell":1,"id":2,"widget_id":"4946cd9b-a752-474b-bae7-80a48e6bf842","style":{"widget_css":"margin-bottom: 21px;","background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"Send us a Message","text":"<p>Feel free to ask any questions over the phone, or get in touch via our contact form below. Your message will be dispatched directly to our staff who will answer as soon as they can.</p>","text_selected_editor":"tinymce","autop":true,"_sow_form_id":"56a7ee37d914e","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":1,"id":3,"widget_id":"19132bba-1900-4355-a32a-18663cf84bec","style":{"background_display":"tile","big_widget_title":"","small_widget_title":true,"white_widget_title":"","featured_box":"","white_featured_box":""}}},{"title":"","text":"<p>[contact-form-7 id=\"7485\" title=\"Contact Form\"]</p>","text_selected_editor":"tmce","autop":true,"_sow_form_id":"56a802ec741da","panels_info":{"class":"SiteOrigin_Widget_Editor_Widget","raw":false,"grid":0,"cell":1,"id":4,"widget_id":"06af6385-a2ba-40e6-8476-44d90796f36b","style":{"padding":"40px","background":"#f5f8fb","background_display":"tile","big_widget_title":"","small_widget_title":"","white_widget_title":"","featured_box":"","white_featured_box":""}}}],"grids":[{"cells":2,"style":{"bottom_margin":"0px","gutter":"40px","background_image_attachment":false,"background_display":"tile"}}],"grid_cells":[{"grid":0,"index":0,"weight":0.275,"style":{}},{"grid":0,"index":1,"weight":0.725,"style":{}}],"name":"Contact Us"}', true )
        );

        return $layouts;
    }
    add_filter( 'siteorigin_panels_prebuilt_layouts', 'physio_qt_prebuilt_page_layouts' );
}