<?php

/**
 * Loading all ACF fields and options from this file
 */

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array (
	'key' => 'group_5656136da36c1',
	'title' => 'Page Subtitle',
	'fields' => array (
		array (
			'key' => 'field_5656137207688',
			'label' => '',
			'name' => 'subtitle',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => 'Page Subtitle',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0,
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-jumbtron.php',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-slider-premium.php',
			),
		),
	),
	'menu_order' => 1,
	'position' => 'acf_after_title',
	'style' => 'seamless',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_565614e5b6a4d',
	'title' => 'Alternative Slider Option',
	'fields' => array (
		array (
			'key' => 'field_5656151f21ae4',
			'label' => 'Use this Slider',
			'name' => 'use_this_slider',
			'type' => 'radio',
			'instructions' => 'If you prefer Revolution Slider or Layout Slider you can use them with this theme. Select which slider you want to use and fill in the <strong>ID only.</strong> Please note that both sliders are not included, you can buy Revolution Slider <a href="http://codecanyon.net/item/slider-revolution-responsive-wordpress-plugin/2751380?ref=QreativeThemes">here</a> and Layer Slider <a href="http://codecanyon.net/item/layerslider-responsive-wordpress-slider-plugin-/1362246?ref=QreativeThemes">here</a>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'rev' => 'Revolution Slider',
				'layer' => 'Layer Slider',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5656154721ae5',
			'label' => 'Revolution Slider',
			'name' => 'revolution_slider_id',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_5656151f21ae4',
						'operator' => '==',
						'value' => 'rev',
					),
				),
			),
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_5656155d21ae6',
			'label' => 'Layer Slider',
			'name' => 'layer_slider_id',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_5656151f21ae4',
						'operator' => '==',
						'value' => 'layer',
					),
				),
				array (
					array (
						'field' => 'field_5656151f21ae4',
						'operator' => '==',
						'value' => 'layer',
					),
				),
			),
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0,
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-front-slider-premium.php',
			),
		),
	),
	'menu_order' => 2,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_56561139cbe1f',
	'title' => 'Page Slider',
	'fields' => array (
		array (
			'key' => 'field_58a1e6d98c4c9',
			'label' => 'Slides',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array (
			'key' => 'field_56561180d769e',
			'label' => '',
			'name' => 'slides',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => '',
			'max' => '',
			'layout' => 'block',
			'button_label' => 'Add New Slide',
			'sub_fields' => array (
				array(
					'key' => 'field_5e8f3c0af7aaf',
					'label' => 'Slide Image',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array (
					'key' => 'field_565611f5d769f',
					'label' => 'Image',
					'name' => 'slide_image',
					'type' => 'image',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'id',
					'preview_size' => 'medium',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array (
					'key' => 'field_56561229d76a0',
					'label' => 'Top heading',
					'name' => 'slide_small_heading',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_56561143d769d',
								'operator' => '==',
								'value' => 'use_captions',
							),
						),
					),
					'wrapper' => array (
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array (
					'key' => 'field_56561246d76a1',
					'label' => 'Heading',
					'name' => 'slide_heading',
					'type' => 'textarea',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_56561143d769d',
								'operator' => '==',
								'value' => 'use_captions',
							),
						),
					),
					'wrapper' => array (
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => 3,
					'new_lines' => 'br',
				),
				array (
					'key' => 'field_5656126fd76a2',
					'label' => 'Content',
					'name' => 'slide_content',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_56561143d769d',
								'operator' => '==',
								'value' => 'use_captions',
							),
						),
					),
					'wrapper' => array (
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'visual',
					'toolbar' => 'basic',
					'media_upload' => 0,
				),
				array (
					'key' => 'field_56717e88b42fb',
					'label' => 'Link slide',
					'name' => 'slide_link',
					'type' => 'text',
					'instructions' => '(Optional) Link the image to a URL',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_56561143d769d',
								'operator' => '==',
								'value' => 'no_captions',
							),
						),
					),
					'wrapper' => array (
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array (
					'key' => 'field_5671849ba861b',
					'label' => 'Target link',
					'name' => 'slide_link_target',
					'type' => 'radio',
					'instructions' => 'Open link in new browser window?',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_56561143d769d',
								'operator' => '==',
								'value' => 'no_captions',
							),
						),
					),
					'wrapper' => array (
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'choices' => array (
						'no' => 'No',
						'yes' => 'Yes',
					),
					'allow_null' => 0,
					'other_choice' => 0,
					'save_other_choice' => 0,
					'default_value' => '',
					'layout' => 'horizontal',
					'return_format' => 'value',
				),
				array(
					'key' => 'field_5bd1e6522d3bd',
					'label' => 'Buttons',
					'name' => 'slide_buttons',
					'type' => 'repeater',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'collapsed' => '',
					'min' => 0,
					'max' => 2,
					'layout' => 'table',
					'button_label' => 'Add Button',
					'sub_fields' => array(
						array(
							'key' => 'field_5bd1e6662d3be',
							'label' => 'Button Link',
							'name' => 'slide_button_link',
							'type' => 'link',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'url',
						),
						array(
							'key' => 'field_5bd1e67d2d3bf',
							'label' => 'Button Text',
							'name' => 'slide_button_text',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5bd1e68c2d3c0',
							'label' => 'Button Style',
							'name' => 'slide_button_style',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'primary' => 'Primary',
								'outline' => 'Outline',
							),
							'default_value' => array(
								0 => 'primary',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
					),
				),
				array(
					'key' => 'field_5e8f3c22f7ab0',
					'label' => 'Slide Settings',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array(
					'key' => 'field_5e8f3ea308b8a',
					'label' => 'Top Heading Color',
					'name' => 'slide_subheading_color',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
				),
				array(
					'key' => 'field_5e8f3ec808b8b',
					'label' => 'Heading Color',
					'name' => 'slide_heading_color',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
				),
				array(
					'key' => 'field_5e8f42dfd1f65',
					'label' => 'Content Color',
					'name' => 'slide_content_color',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
				),
				array(
					'key' => 'field_5da47df9b2fe2',
					'label' => 'Overlay Color',
					'name' => 'slide_overlay_color',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
				),
				array(
					'key' => 'field_5da47e27b2fe3',
					'label' => 'Overlay Opacity',
					'name' => 'slide_overlay_opacity',
					'type' => 'range',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'min' => 0,
					'max' => 1,
					'step' => '0.1',
					'prepend' => 0,
					'append' => '',
				),
				array(
					'key' => 'field_5e8f49756060e',
					'label' => 'Button Colors',
					'name' => 'button_colors',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5e8f478251dca',
							'label' => 'Button Default',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5e8f456f9dc2a',
							'label' => 'Text Color',
							'name' => 'slide_button_color',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => 'clear clearfix',
								'id' => '',
							),
							'default_value' => '',
						),
						array(
							'key' => 'field_5e8f45239dc27',
							'label' => 'Background',
							'name' => 'slide_button_background',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
						),
						array(
							'key' => 'field_5e8f45579dc29',
							'label' => 'Background Hover',
							'name' => 'slide_button_background_hover',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
						),
						array(
							'key' => 'field_5e8f47cd51dcb',
							'label' => 'Button Outline',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5e8f47f951dcd',
							'label' => 'Text Color',
							'name' => 'slide_button_outline_color',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => 'clear clearfix',
								'id' => '',
							),
							'default_value' => '',
						),
						array(
							'key' => 'field_5e8f480c51dce',
							'label' => 'Border',
							'name' => 'slide_button_outline_border',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
						),
						array(
							'key' => 'field_5e8f482151dcf',
							'label' => 'Border Hover',
							'name' => 'slide_button_outline_border_hover',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
						),
					),
				),
				array(
					'key' => 'field_5e903dfd534b4',
					'label' => 'Caption Align',
					'name' => 'slide_caption_align',
					'type' => 'button_group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'left' => '<i class="dashicons dashicons-editor-alignleft"></i>',
						'center' => '<i class="dashicons dashicons-editor-aligncenter"></i>',
						'right' => '<i class="dashicons dashicons-editor-alignright"></i>',
					),
					'allow_null' => 1,
					'default_value' => 'left',
					'layout' => 'horizontal',
					'return_format' => 'value',
				),
				array(
					'key' => 'field_5ed8fb74d2e13',
					'label' => 'Heading Tag',
					'name' => 'slide_heading_tag',
					'type' => 'select',
					'instructions' => 'Change the tag of the main heading for this slide, for SEO purpose',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'h1' => 'H1',
						'h2' => 'H2',
						'h3' => 'H3',
						'h4' => 'H4',
						'h5' => 'H5',
						'h6' => 'H6',
					),
					'default_value' => 'h1',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
			),
		),
		array (
			'key' => 'field_58a1e6ee8c4ca',
			'label' => 'Settings',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array (
			'key' => 'field_5671882add8de',
			'label' => 'Animation',
			'name' => 'slide_animation',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '100',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'carousel-slide' => 'Slide',
				'carousel-fade' => 'Fade',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5656129fd76a3',
			'label' => 'Autocycle',
			'name' => 'slide_autocycle',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => 'Yes',
			'ui_off_text' => 'No',
		),
		array (
			'key' => 'field_565612ded76a4',
			'label' => 'Interval',
			'name' => 'slide_interval',
			'type' => 'number',
			'instructions' => 'Cycle interval (1s = 1000ms)',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_5656129fd76a3',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 8000,
			'placeholder' => '',
			'prepend' => '',
			'append' => 'ms',
			'min' => '',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5ace568bba4ef',
			'label' => 'Pause on hover',
			'name' => 'pause_hover',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5656129fd76a3',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => 'Yes',
			'ui_off_text' => 'No',
		),
		array (
			'key' => 'field_56561143d769d',
			'label' => 'Slide captions',
			'name' => 'slide_captions',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'use_captions' => 'Show captions',
				'no_captions' => 'Hide captions',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'use_captions',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array(
			'key' => 'field_58ece3ee9b1d2',
			'label' => 'Caption alignment',
			'name' => 'slide_caption_alignment',
			'type' => 'button_group',
			'instructions' => 'Change the caption alignment for all slides',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_56561143d769d',
						'operator' => '==',
						'value' => 'use_captions',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'left' => '<i class="dashicons dashicons-editor-alignleft"></i>',
				'center' => '<i class="dashicons dashicons-editor-aligncenter"></i>',
				'right' => '<i class="dashicons dashicons-editor-alignright"></i>',
			),
			'allow_null' => 0,
			'default_value' => 'left',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5a033522353c0',
			'label' => 'Touch support',
			'name' => 'enable_touch_support',
			'type' => 'true_false',
			'value' => NULL,
			'instructions' => 'Enable swiping support',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => 'Yes',
			'ui_off_text' => 'No',
		),
		array(
			'key' => 'field_5ddd5908d3d19',
			'label' => 'Fixed Height',
			'name' => 'slide_fixed_height',
			'type' => 'true_false',
			'instructions' => 'Set a fixed height to the slider for each device',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => 'Yes',
			'ui_off_text' => 'No',
		),
		array(
			'key' => 'field_5ddd5933d3d1a',
			'label' => 'Height Mobile',
			'name' => 'slide_height_mobile',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ddd5908d3d19',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '24',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '0',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5ddd5971d3d1b',
			'label' => 'Height Tablet',
			'name' => 'slide_height_tablet',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ddd5908d3d19',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '24',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '0',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5ddd597fd3d1c',
			'label' => 'Height (Small) Desktop',
			'name' => 'slide_height_desktop_small',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ddd5908d3d19',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '26',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '0',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5ddd60112ee8f',
			'label' => 'Height (Large) Desktop',
			'name' => 'slide_height_desktop_large',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ddd5908d3d19',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '26',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '0',
			'max' => '',
			'step' => '',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-front-jumbtron.php',
			),
		),
	),
	'menu_order' => 3,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_5655fd6b3b271',
	'title' => 'Header settings',
	'fields' => array (
		array (
			'key' => 'field_573f002b12837',
			'label' => 'Settings',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array (
			'key' => 'field_573eff8212835',
			'label' => 'Topbar',
			'name' => 'topbar',
			'type' => 'radio',
			'instructions' => 'Show or hide the topbar',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'show' => 'Show',
				'hide' => 'Hide',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'allow_null' => 1,
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5821cb1834a9e',
			'label' => 'Header widgets',
			'name' => 'widget_bar',
			'type' => 'radio',
			'instructions' => 'Show or hide the header widget bar',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'show' => 'Show',
				'hide' => 'Hide',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5821d82b57218',
			'label' => 'Page header',
			'name' => 'page_header',
			'type' => 'radio',
			'instructions' => 'Show or hide the page header',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'show' => 'Show',
				'hide' => 'Hide',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_573effb412836',
			'label' => 'Pages header alignment',
			'name' => 'header_text_align',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'left' => 'Left',
				'center' => 'Center',
				'right' => 'Right',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'left',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_573f0176dc619',
			'label' => 'Page title',
			'name' => 'display_page_title',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'show' => 'Show',
				'hide' => 'Hide',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_56a7a33f17e79',
			'label' => 'Page title color',
			'name' => 'page_title_color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array (
			'key' => 'field_573f01aadc61a',
			'label' => 'Subtitle color',
			'name' => 'subtitle_color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array (
			'key' => 'field_5821dbb10d926',
			'label' => 'Breadcrumbs',
			'name' => 'breadcrumbs',
			'type' => 'radio',
			'instructions' => 'Show or hide the breadcrumbs',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'show' => 'Show',
				'hide' => 'Hide',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_573f003f12838',
			'label' => 'Background',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array (
			'key' => 'field_5655fda0b8697',
			'label' => 'Background image',
			'name' => 'header_bg',
			'type' => 'image',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'preview_size' => 'medium',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array (
			'key' => 'field_5655fe25b8698',
			'label' => 'Background image horizontal position',
			'name' => 'header_bg_horizontal',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'left' => 'Left',
				'center' => 'Center',
				'right' => 'Right',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'left',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5655fe6bb8699',
			'label' => 'Background image vertical position',
			'name' => 'header_bg_vertical',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'top' => 'Top',
				'center' => 'Center',
				'bottom' => 'Bottom',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5655fe8bb869a',
			'label' => 'Background image size',
			'name' => 'header_bg_size',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'auto' => 'Auto',
				'cover' => 'Cover',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5655fea3b869b',
			'label' => 'Background image attachment',
			'name' => 'header_bg_attachment',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'scroll' => 'Scroll',
				'fixed' => 'Fixed',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5655fee3b869c',
			'label' => 'Background color',
			'name' => 'header_bg_color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-jumbtron.php',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-slider-premium.php',
			),
		),
	),
	'menu_order' => 4,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_5655eb257204f',
	'title' => 'Sidebar Settings',
	'fields' => array (
		array (
			'key' => 'field_5655eb4b31ecd',
			'label' => 'Display sidebar',
			'name' => 'sidebar',
			'type' => 'radio',
			'instructions' => 'Set the position of the sidebar on this page',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'hide' => 'Hide',
				'left' => 'Left',
				'right' => 'Right',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'right',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5655f6b4f706f',
			'label' => 'Pull sidebar',
			'name' => 'pull_sidebar',
			'type' => 'radio',
			'instructions' => 'Pull the sidebar to overlap the page heading',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_5655eb4b31ecd',
						'operator' => '==',
						'value' => 'left',
					),
				),
				array (
					array (
						'field' => 'field_5655eb4b31ecd',
						'operator' => '==',
						'value' => 'right',
					),
				),
			),
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'no_pull' => 'Don\'t Pull Sidebar',
				'pull' => 'Pull Sidebar',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'no_pull',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-jumbtron.php',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-slider-premium.php',
			),
		),
	),
	'menu_order' => 5,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

endif;